
// ntlib.h
// 11-15-1998 Sven B. Schreiber
// sbs@orgon.com

#define UNICODE

////////////////////////////////////////////////////////////////////
#ifdef _NTLIB_DLL_
////////////////////////////////////////////////////////////////////

// =================================================================
// PROGRAM IDENTIFICATION
// =================================================================

#define MAIN_BUILD              1
#define MAIN_VERSION_HIGH       1
#define MAIN_VERSION_LOW        0

// -----------------------------------------------------------------

#define MAIN_DAY                15
#define MAIN_MONTH              11
#define MAIN_YEAR               1998

// -----------------------------------------------------------------

#define MAIN_PREFIX             SBS
#define MAIN_MODULE             ntlib
#define MAIN_NAME               Windows NT Utility Library
#define MAIN_COMPANY            Sven B. Schreiber
#define MAIN_AUTHOR             Sven B. Schreiber
#define MAIN_EMAIL              sbs@orgon.com
#define MAIN_DLL

////////////////////////////////////////////////////////////////////
#endif // #ifdef _NTLIB_DLL_
////////////////////////////////////////////////////////////////////

// =================================================================
// HEADER FILES
// =================================================================

#define  NtCurrentTeb NTAPI NtCurrentTeb
#include <proginfo.h>
#undef   NtCurrentTeb

////////////////////////////////////////////////////////////////////
#ifndef _RC_PASS_
////////////////////////////////////////////////////////////////////

// =================================================================
// MORE HEADER FILES
// =================================================================

#include <ntdll.h>

// =================================================================
// CONSTANTS
// =================================================================

#define NTL_INFO_SYSTEM             1
#define NTL_INFO_PROCESS            2
#define NTL_INFO_THREAD             3
#define NTL_INFO_LOADER             4

// -----------------------------------------------------------------

#define NTL_STATUS_OPENED           0x00000001
#define NTL_STATUS_CREATED          0x00000002
#define NTL_STATUS_STARTED          0x00000004
#define NTL_STATUS_RUNNING          0x00000008

// -----------------------------------------------------------------

#define NTL_CMD_PARAMETERS          100

#define NTL_CMD_FLAG_ALL            0x00000001
#define NTL_CMD_FLAG_THIS           0x00000002
#define NTL_CMD_FLAG_NAMED          0x00000004

#define NTL_CMD_CALLBACK_OVERFLOW   0   // parameter overflow
#define NTL_CMD_CALLBACK_INVALID    1   // invalid option id
#define NTL_CMD_CALLBACK_AMBIGUOUS  2   // ambiguous option id
#define NTL_CMD_CALLBACK_ENUMERATE  3   // enumeration of option ids

// -----------------------------------------------------------------

#define NTL_UNIT_TABLE              0x00010000

// -----------------------------------------------------------------

#define CSTR_LESS_THAN              1
#define CSTR_EQUAL                  2
#define CSTR_GREATER_THAN           3

#define NTL_WVSPRINTF               1024

// =================================================================
// STANDARD TABLE PARAMETERS
// =================================================================

#define NTL_TABLE_COUNT             0x00000001  // entry count
#define NTL_TABLE_FIXED             0x00000002  // fixed length
#define NTL_TABLE_ABSOLUTE          0x00000004  // absolute links

// -----------------------------------------------------------------

#define NTL_CPU_HEADER              0
#define NTL_CPU_ENTRY               SYSTEM_PROCESSOR_COUNTERS_
#define NTL_CPU_ATTRIBUTES          NTL_TABLE_FIXED

// -----------------------------------------------------------------

#define NTL_HANDLE_HEADER           SYSTEM_HANDLE_INFORMATION_
#define NTL_HANDLE_ENTRY            SYSTEM_HANDLE_
#define NTL_HANDLE_ATTRIBUTES       (NTL_TABLE_COUNT | \
                                     NTL_TABLE_FIXED)

// -----------------------------------------------------------------

#define NTL_LOCK_HEADER             SYSTEM_LOCK_INFORMATION_
#define NTL_LOCK_ENTRY              SYSTEM_LOCK_
#define NTL_LOCK_ATTRIBUTES         (NTL_TABLE_COUNT | \
                                     NTL_TABLE_FIXED)

// -----------------------------------------------------------------

#define NTL_LOOKASIDE_HEADER        0
#define NTL_LOOKASIDE_ENTRY         SYSTEM_LOOKASIDE_
#define NTL_LOOKASIDE_ATTRIBUTES    NTL_TABLE_FIXED

// -----------------------------------------------------------------

#define NTL_MODULE_HEADER           SYSTEM_MODULE_INFORMATION_
#define NTL_MODULE_ENTRY            SYSTEM_MODULE_
#define NTL_MODULE_ATTRIBUTES       (NTL_TABLE_COUNT | \
                                     NTL_TABLE_FIXED)

// -----------------------------------------------------------------

#define NTL_PAGE_FILE_HEADER        0
#define NTL_PAGE_FILE_ENTRY         SYSTEM_PAGE_FILE_INFORMATION_
#define NTL_PAGE_FILE_ATTRIBUTES    0

// -----------------------------------------------------------------

#define NTL_OBJECT_HEADER           0
#define NTL_OBJECT_ENTRY            SYSTEM_OBJECT_INFORMATION_
#define NTL_OBJECT_ATTRIBUTES       NTL_TABLE_ABSOLUTE

// -----------------------------------------------------------------

#define NTL_PROCESS_HEADER          0
#define NTL_PROCESS_ENTRY           SYSTEM_PROCESS_INFORMATION_
#define NTL_PROCESS_ATTRIBUTES      0

// =================================================================
// ENUMERATIONS
// =================================================================

typedef enum _LOADERINFOCLASS
    {
    LoaderProcessModuleInformation,
    MaxLoaderInfoClass
    }
    LOADERINFOCLASS, *PLOADERINFOCLASS, **PPLOADERINFOCLASS;

// =================================================================
// STRUCTURES
// =================================================================

typedef struct _NTL_CMD_OPTION
    {
    PTBYTE ptName;
    PTBYTE ptTail;
    PROC   Handler;
    }
    NTL_CMD_OPTION, *PNTL_CMD_OPTION, **PPNTL_CMD_OPTION;

#define NTL_CMD_OPTION_ sizeof (NTL_CMD_OPTION)

// -----------------------------------------------------------------

typedef struct _NTL_CMD_FLAG
    {
    PTBYTE ptName;
    DWORD  dMask;
    }
    NTL_CMD_FLAG, *PNTL_CMD_FLAG, **PPNTL_CMD_FLAG;

#define NTL_CMD_FLAG_ sizeof (NTL_CMD_FLAG)

// -----------------------------------------------------------------

typedef struct _NTL_CMD_PARAMETER
    {
    PTBYTE ptValue;
    DWORD  dValue;
    BOOL   fNumeric;
    }
    NTL_CMD_PARAMETER, *PNTL_CMD_PARAMETER, **PPNTL_CMD_PARAMETER;

#define NTL_CMD_PARAMETER_ sizeof (NTL_CMD_PARAMETER)   

// -----------------------------------------------------------------

typedef struct _NTL_CMD_DATA
    {
    PNTL_CMD_OPTION   pnco;
    PNTL_CMD_FLAG     pncfTable;
    TBYTE             tPrefix;
    DWORD             dFlags;
    DWORD             dCount;
    DWORD             dNumbers;
    NTL_CMD_PARAMETER ancp [NTL_CMD_PARAMETERS];
    }
    NTL_CMD_DATA, *PNTL_CMD_DATA, **PPNTL_CMD_DATA;

#define NTL_CMD_DATA_ sizeof (NTL_CMD_DATA)

// -----------------------------------------------------------------

typedef struct _NTL_TABLE
    {
    PVOID pData;
    DWORD dData;
    DWORD dHeader;
    DWORD dEntry;
    DWORD dFlags;
    DWORD dIndex;
    DWORD dCount;
    }
    NTL_TABLE, *PNTL_TABLE, **PPNTL_TABLE;

#define NTL_TABLE_ sizeof (NTL_TABLE)

// -----------------------------------------------------------------

typedef struct _NTL_LOOKUP
    {
    DWORD  dCode;
    PTBYTE ptName;
    }
    NTL_LOOKUP, *PNTL_LOOKUP, **PPNTL_LOOKUP;

#define NTL_LOOKUP_ sizeof (NTL_LOOKUP)

// =================================================================
// CALLBACK TYPES
// =================================================================

typedef BOOL (CALLBACK *PNTL_CMD_CALLBACK) (DWORD  dEvent,
                                            TBYTE  tPrefix,
                                            PTBYTE ptData,
                                            PVOID  pClient);

// =================================================================
// API PROTOTYPES
// =================================================================

int WINAPI
NtlBox (HWND   hWnd,
        UINT   uType,
        PTBYTE ptCaption,
        PTBYTE ptFormat,
        ...);

PVOID WINAPI
NtlPointerFs (DWORD dOffset);

PTEB WINAPI
NtlPointerTeb (void);

PPEB WINAPI
NtlPointerPeb (void);

BOOL WINAPI
NtlDeviceClose (PHANDLE phDevice);

BOOL WINAPI
NtlDeviceOpen (PHANDLE phDevice,
               PTBYTE  atPath);

DWORD WINAPI
NtlDeviceStop (PTBYTE atName,
               DWORD  dStatus);

DWORD WINAPI
NtlDeviceStart (PTBYTE atName,
                PTBYTE atDisplay,
                PTBYTE atFile);

DWORD WINAPI
NtlDeviceCloseEx (PHANDLE phDevice,
                  PTBYTE  atName,
                  DWORD   dStatus);

DWORD WINAPI
NtlDeviceOpenEx (PHANDLE phDevice,
                 PTBYTE  atName,
                 PTBYTE  atDisplay,
                 PTBYTE  atFile,
                 PTBYTE  atPath);

PNTL_CMD_OPTION WINAPI
NtlCommandEnumerate (PNTL_CMD_OPTION pncoTable,
                     PTBYTE          ptName,
                     PDWORD          pdIndex);

PNTL_CMD_OPTION WINAPI
NtlCommandOption (PNTL_CMD_OPTION pncoTable,
                  PTBYTE          ptName,
                  PBOOL           pfAmbiguous);

void WINAPI
NtlCommandFlag (PNTL_CMD_FLAG pncfTable,
                PTBYTE        ptName,
                PDWORD        pdFlags);

void WINAPI
NtlCommandParameter (PTBYTE             ptValue,
                     PNTL_CMD_PARAMETER pncp);

BOOL WINAPI
NtlCommandExecute (PNTL_CMD_DATA pncd);

DWORD WINAPI
NtlCommandEvaluate (PNTL_CMD_OPTION   pncoTable,
                    PNTL_CMD_FLAG     pncfTable,
                    PTBYTE            ptPrefixes,
                    PPTBYTE           pptData,
                    DWORD             dCount,
                    PNTL_CMD_CALLBACK CmdCallback,
                    PVOID             pClient);

PVOID WINAPI
NtlListNext (PLIST_ENTRY pleHead,
             DWORD       dOffset,
             PVOID       pCurrent);

PVOID WINAPI
NtlListFirst (PLIST_ENTRY pleHead,
              DWORD       dOffset);

NTSTATUS WINAPI
NtlTableReset (PNTL_TABLE pnt,
               PVOID      pData,
               DWORD      dData);

NTSTATUS WINAPI
NtlTableResetEx (PNTL_TABLE pnt,
                 PVOID      pData,
                 DWORD      dData,
                 DWORD      dHeader,
                 DWORD      dEntry,
                 DWORD      dFlags,
                 BOOL       fCount);

NTSTATUS WINAPI
NtlTableLoad (PNTL_TABLE pnt,
              DWORD      dInfoGroup,
              DWORD      dInfoClass,
              HANDLE     hObject);

NTSTATUS WINAPI
NtlTableLoadEx (PNTL_TABLE pnt,
                DWORD      dInfoGroup,
                DWORD      dInfoClass,
                HANDLE     hObject,
                DWORD      dHeader,
                DWORD      dEntry,
                DWORD      dFlags);

NTSTATUS WINAPI
NtlTableUnload (PNTL_TABLE pnt);

DWORD WINAPI
NtlTableSize (PNTL_TABLE pnt);

DWORD WINAPI
NtlTableCount (PNTL_TABLE pnt);

PVOID WINAPI
NtlTableFirst (PNTL_TABLE pnt);

PVOID WINAPI
NtlTableNext (PNTL_TABLE pnt,
              PVOID      pEntry);

NTSTATUS WINAPI
NtlTableCpu (PNTL_TABLE pnt);

NTSTATUS WINAPI
NtlTableHandle (PNTL_TABLE pnt);

NTSTATUS WINAPI
NtlTableLock (PNTL_TABLE pnt);

NTSTATUS WINAPI
NtlTableLookaside (PNTL_TABLE pnt);

NTSTATUS WINAPI
NtlTableModule (PNTL_TABLE pnt,
                BOOL       fProcess);

NTSTATUS WINAPI
NtlTablePageFile (PNTL_TABLE pnt);

NTSTATUS WINAPI
NtlTableObject (PNTL_TABLE pnt);

NTSTATUS WINAPI
NtlTableProcess (PNTL_TABLE pnt);

PSYSTEM_OBJECT WINAPI
NtlTableObjectFirst (PNTL_TABLE                 pntSub,
                     PNTL_TABLE                 pnt,
                     PSYSTEM_OBJECT_INFORMATION psoi);

PSYSTEM_OBJECT WINAPI
NtlTableObjectNext (PNTL_TABLE     pntSub,
                    PSYSTEM_OBJECT pso);

NTSTATUS WINAPI
NtlInfoRead (PVOID  pData,
             PDWORD pdData,
             DWORD  dInfoGroup,
             DWORD  dInfoClass,
             HANDLE hObject);

DWORD WINAPI
NtlBytesToKb (DWORD dBytes);

DWORD WINAPI
NtlBytesToMb (DWORD dBytes);

DWORD WINAPI
NtlBytesToGb (DWORD dBytes);

DWORD WINAPI
NtlBytesToPages (DWORD dBytes);

DWORD WINAPI
NtlPagesToBytes (DWORD dPages);

DWORD WINAPI
NtlPagesToKb (DWORD dPages);

DWORD WINAPI
NtlPagesToMb (DWORD dPages);

DWORD WINAPI
NtlPagesToGb (DWORD dPages);

void WINAPI
NtlTimeReset (PQWORD pqTime);

DWORD WINAPI
NtlTimeUnits (PQWORD pqTime,
              DWORD  dUnit);

DWORD WINAPI
NtlTimeInterval (PQWORD pqTime1,
                 PQWORD pqTime2,
                 PQWORD pqInterval,
                 DWORD  dUnit);

void WINAPI
NtlTimeExtend (PQWORD pqTime,
               PQWORD pqInterval,
               DWORD  dUnit);

BOOL WINAPI
NtlTimePack (PTIME_FIELDS ptfTime,
             PQWORD       pqTime);

void WINAPI
NtlTimeUnpack (PQWORD       pqTime,
               PTIME_FIELDS ptfTime);

PTBYTE WINAPI
NtlNameLookup (PNTL_LOOKUP pnl,
               DWORD       dCount,
               DWORD       dCode,
               PDWORD      pdSize,
               PDWORD      pdSizeMax);

PTBYTE WINAPI
NtlNameObjectType (DWORD  dType,
                   PDWORD pdSize,
                   PDWORD pdSizeMax);

PTBYTE WINAPI
NtlNamePoolType (DWORD  dType,
                 PDWORD pdSize,
                 PDWORD pdSizeMax);

// =================================================================
// LINKER CONTROL
// =================================================================

#ifdef _NTLIB_DLL_
#pragma comment (linker, "/entry:\"DllMain\"")
#else
#pragma comment (linker, "/defaultlib:ntlib.lib")
#endif

////////////////////////////////////////////////////////////////////
#endif // #ifndef _RC_PASS_
////////////////////////////////////////////////////////////////////

// =================================================================
// END OF FILE
// =================================================================
